<?php
function elyssa_ai_add_admin_menu()
{
    // Hauptmenüpunkt
    add_menu_page(
        __('elyssa AI', 'elyssa-ai'), // Seite Titel
        __('elyssa AI', 'elyssa-ai'), // Menü Titel
        'manage_options', // Capability
        'elyssa-ai', // Menü-Slug
        'elyssa_ai_generate_page', // Funktion für die Hauptseite
        plugin_dir_url(__FILE__) . '../images/elyssa-icon-white.webp', // Icon URL
        110 // Position
    );

    // Untermenüpunkt "Generate Articles"
    add_submenu_page(
        'elyssa-ai', // Übergeordneter Slug
        __('Generate Articles', 'elyssa-ai'), // Seitentitel
        __('Generate Articles', 'elyssa-ai'), // Menütitel
        'manage_options', // Capability
        'elyssa-ai', // Slug (gleich wie Hauptmenü für die gleiche Seite)
        'elyssa_ai_generate_page' // Funktion
    );

    // Neuer Untermenüpunkt "Bulk Generation"
    add_submenu_page(
        'elyssa-ai',
        __('Bulk Generation', 'elyssa-ai'),
        __('Bulk Generation', 'elyssa-ai'),
        'manage_options',
        'elyssa-ai-bulk',
        array(ElyssaAIBulk::get_instance(), 'bulk_page')
    );

    // Untermenüpunkt "Settings"
    add_submenu_page(
        'elyssa-ai', // Übergeordneter Slug
        __('Settings', 'elyssa-ai'), // Seitentitel
        __('Settings', 'elyssa-ai'), // Menütitel
        'manage_options', // Capability
        'elyssa-ai-settings', // Neuer Slug für die Einstellungsseite
        'elyssa_ai_settings_page' // Funktion
    );
}

add_action('admin_menu', 'elyssa_ai_add_admin_menu');

// Die bestehenden Funktionen für versteckte Seiten können beibehalten werden
function elyssa_ai_register_hidden_lib_page()
{
    add_submenu_page(
        null, // Kein übergeordnetes Menü
        __('Log', 'elyssa-ai'), // Seitentitel
        null, // Kein Menütitel
        'manage_options', // Capability
        'elyssa-ai-lib', // Slug
        'elyssa_ai_lib_page_callback' // Funktion
    );
}

add_action('admin_menu', 'elyssa_ai_register_hidden_lib_page');

function elyssa_ai_add_registration_menu()
{
    add_submenu_page(
        'elyssa-ai',
        __('Registration', 'elyssa-ai'),
        __('Registration', 'elyssa-ai'),
        'manage_options',
        'elyssa-ai-registration',
        'elyssa_ai_registration_page'
    );
}

add_action('admin_menu', 'elyssa_ai_add_registration_menu', 1000);

// Lade die Update-Debug-Seite, wenn Logging aktiviert ist
function elyssa_ai_load_debug_page() {
    if (get_option('elyssa_ai_logging_enabled')) {
        require_once ELYSSA_AI_PLUGIN_DIR . 'admin/pages/elyssa-update-debug.php';
    }
}
add_action('admin_init', 'elyssa_ai_load_debug_page');


function custom_menu_icon_css() {
    $custom_css = '
        li.toplevel_page_elyssa-ai a div.wp-menu-image img {
            width: 20px;
            margin-top: -3px !important;
            margin-left: 0px !important;
        }
        
        li.toplevel_page_elyssa-ai a.wp-menu-open div.wp-menu-image img {
            margin-left: 8px !important;
        }
        
        li.toplevel_page_elyssa-ai a.wp-has-current-submenu {
            background-color: #794AFF !important;
        }
    ';
    wp_register_style('elyssa-ai-menu-icon-css', false);
    wp_enqueue_style('elyssa-ai-menu-icon-css');
    wp_add_inline_style('elyssa-ai-menu-icon-css', $custom_css);
}
add_action('admin_head', 'custom_menu_icon_css');