<?php
function elyssa_ai_generate_page() {
	include ELYSSA_AI_ROOT_PATH . 'admin/html/header.php';
    $prompts = ElyssaAIPrompts::get_prompts_for_dropdown();
    ?>
    <div class="w-3/6 space-y-8">
        <section class="bg-white p-6 shadow-md rounded-lg">
            <h2 class="text-xl font-semibold mb-4"><?php esc_html_e('What do you want to create today?', 'elyssa-ai'); ?></h2>
            <div class="w-full mx-auto p-6">
                <div class="mb-6">
                    <div class="flex space-x-4">
                        <div class="flex-1">
                            <label for="content-type" class="block text-sm font-medium text-gray-700"><?php esc_html_e('Content Type', 'elyssa-ai'); ?></label>
                            <div class="mt-1">
                                <select id="elyssa_ai_create_type" name="content-type"
                                        class="block w-full border border-gray-400">
                                    <option value="posts"><?php esc_html_e('Posts', 'elyssa-ai'); ?></option>
                                    <option value="pages"><?php esc_html_e('Pages', 'elyssa-ai'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="flex-1">
                            <label for="tone-of-voice" class="block text-sm font-medium text-gray-700"><?php esc_html_e('Tone of voice', 'elyssa-ai'); ?></label>
                            <div class="mt-1">
                                <select id="elyssa_ai_create_tone_of_voice" name="tone-of-voice"
                                        class="block w-full border border-gray-400">
                                    <option value="Neutral"><?php esc_html_e('Neutral', 'elyssa-ai'); ?></option>
                                    <option value="Formal"><?php esc_html_e('Formal', 'elyssa-ai'); ?></option>
                                    <option value="Trustworthy"><?php esc_html_e('Trustworthy', 'elyssa-ai'); ?></option>
                                    <option value="Friendly"><?php esc_html_e('Friendly', 'elyssa-ai'); ?></option>
                                    <option value="Witty"><?php esc_html_e('Witty', 'elyssa-ai'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="flex-1">
                            <label for="content-length" class="block text-sm font-medium text-gray-700"><?php esc_html_e('Content length', 'elyssa-ai'); ?></label>
                            <div class="mt-1">
                                <select id="elyssa_ai_create_length" name="content-length"
                                        class="block w-full border border-gray-400">
                                    <option value="Short"><?php esc_html_e('Short (300 to 600 Words)', 'elyssa-ai'); ?></option>
                                    <option value="Medium"><?php esc_html_e('Medium (600 to 1000 Words)', 'elyssa-ai'); ?></option>
                                    <option value="Large"><?php esc_html_e('Large (1000 to 2500 Words)', 'elyssa-ai'); ?></option>
                                    <option value="Extra Large"><?php esc_html_e('Extra Large (2500 to 5000 Words)', 'elyssa-ai'); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mb-6">
                    <label for="elyssa_ai_prompt_select" class="block text-lg font-semibold mb-2"><?php esc_html_e('Select a Prompt (Optional)', 'elyssa-ai'); ?></label>
                    <select id="elyssa_ai_prompt_select" name="prompt_id" class="block w-full border border-gray-400 mb-2">
                        <option value=""><?php esc_html_e('Select a prompt or enter your own below', 'elyssa-ai'); ?></option>
                        <?php foreach ($prompts as $id => $title) : ?>
                            <option value="<?php echo esc_attr($id); ?>"><?php echo esc_html($title); ?></option>
                        <?php endforeach; ?>
                    </select>
                    <label for="content-about" class="block text-lg font-semibold mb-2"><?php esc_html_e('What is your content about?', 'elyssa-ai'); ?></label>
                    <textarea id="elyssa_ai_request" name="elyssa_ai_request" rows="4"
                              class="p-3 shadow-sm focus:ring-indigo-500 focus:border-indigo-500 mt-1 block w-full sm:text-sm border border-gray-400 rounded-md"
                              placeholder="<?php esc_html_e('Let us know more about your content idea. For example: Article about how to use WordPress to dive into website development including tutorials how to use it in a simple way...', 'elyssa-ai'); ?>"></textarea>
                </div>

                <div class="mb-6">
                    <label class="flex items-center space-x-2">
                        <input id="elyssa_ai_add_image" class="text-blue-600 form-checkbox w-1/6" type="checkbox"/>
                        <span class="text-gray-700 w-3/6"><?php esc_html_e('Generate Image', 'elyssa-ai'); ?></span>
                        <textarea name="elyssa_ai_image_prompt" id="elyssa_ai_image_prompt" disabled
                                  class="p-2 shadow-sm focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-xs border border-gray-400 rounded-md"
                                  rows="3"
                                  placeholder="<?php esc_html_e('Image prompt', 'elyssa-ai'); ?>"></textarea>
                    </label>
                </div>

                <div class="mb-6">
                    <label for="elyssa_ai_create_keywords" class="block text-lg font-semibold mb-2"><?php esc_html_e('What are the focus keywords of your content?', 'elyssa-ai'); ?></label>
                    <div class="flex">
                        <input type="text" name="focus-keywords" id="elyssa_ai_create_keywords"
                               class="shadow-sm focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border border-gray-400 rounded-md"
                               placeholder="<?php esc_html_e('Example: website development, WordPress tutorial, ...', 'elyssa-ai'); ?>">
                        <button
                                id="elyssa_ai_button"
                                <?php if(!elyssa_is_text_enabled()): ?>title="<?php esc_html_e('Please enable text services in the settings', 'elyssa-ai'); ?>"<?php endif;?>
                                class="elyssa-ai-button" <?php if(!elyssa_is_text_enabled()): ?>disabled<?php endif;?>>
                            <?php esc_html_e('Generate', 'elyssa-ai'); ?>
                        </button>
                    </div>
                    <p class="mt-2 text-sm text-gray-500"><?php esc_html_e('Enter comma to separate keywords', 'elyssa-ai'); ?></p>
                </div>
            </div>
        </section>
    </div>
    <?php
    include ELYSSA_AI_ROOT_PATH . 'admin/pages/elyssa-content-result.php';
    include ELYSSA_AI_ROOT_PATH . 'admin/html/footer.php';
}