document.addEventListener('DOMContentLoaded', function () {
    const button = document.getElementById('elyssa_ai_button');
    const content_wrapper = document.getElementById('elyssa_ai_result_wrapper');
    const content_title = document.getElementById('elyssa_ai_content_title');
    const content_message = document.getElementById('elyssa_ai_content');
    const content_keywords = document.getElementById('elyssa_ai_keywords');
    const result_title = document.getElementById('elyssa_ai_result_title');

    const result_image = document.getElementById('elyssa_ai_result_image');
    const result_image_prompt = document.getElementById('elyssa_ai_image_prompt');

    const create_page = document.getElementById('elyssa_ai_save_page');
    const create_post = document.getElementById('elyssa_ai_save_post');

    const create_type = document.getElementById('elyssa_ai_create_type');
    const create_tone = document.getElementById('elyssa_ai_create_tone_of_voice');
    const create_length = document.getElementById('elyssa_ai_create_length');
    const create_keywords = document.getElementById('elyssa_ai_create_keywords');

    const prompt_select = document.getElementById('elyssa_ai_prompt_select');
    const custom_prompt = document.getElementById('elyssa_ai_request');

    function showLoadingIndicator() {
        if (!document.getElementById('elyssaLoadingIndicator')) {
            const indicator = document.createElement('div');
            indicator.id = 'elyssaLoadingIndicator';
            indicator.textContent = wp.i18n.__('Loading...', 'elyssa-ai');

            Object.assign(indicator.style, {
                position: 'fixed',
                top: '0',
                left: '0',
                width: '100%',
                height: '100%',
                backgroundColor: 'rgba(0, 0, 0, 0.5)',
                color: 'white',
                fontSize: '24px',
                display: 'flex',
                justifyContent: 'center',
                alignItems: 'center',
                zIndex: '9999'
            });

            document.body.appendChild(indicator);
        } else {
            document.getElementById('elyssaLoadingIndicator').style.display = 'flex';
        }
    }

    function hideLoadingIndicator() {
        const indicator = document.getElementById('elyssaLoadingIndicator');
        if (indicator) {
            indicator.style.display = 'none';
        }
    }

    function handlePromptSelection() {
        const selectedPromptId = prompt_select.value;

        if (selectedPromptId) {
            fetch(elyssaAiVars.ajax_url, {
                method: 'POST',
                credentials: 'same-origin',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams({
                    'action': 'elyssa_ai_get_prompt_content',
                    'prompt_id': selectedPromptId,
                    'nonce': elyssaAiVars.nonce
                })
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        custom_prompt.value = data.data.user_prompt;
                    } else {
                        console.error('Error fetching prompt:', data.data.message);
                    }
                })
                .catch(error => {
                    console.error('Fetch error:', error);
                });
        }
    }

    if (prompt_select) {
        prompt_select.addEventListener('change', handlePromptSelection);
    } else {
        console.error('Prompt select element not found');
    }

    if (button) {
        button.addEventListener('click', function () {
            showLoadingIndicator();
            content_title.innerHTML = '';
            content_message.innerHTML = '';
            content_keywords.innerHTML = '';

            const customPromptText = custom_prompt.value;
            const image = document.querySelector(`#elyssa_ai_add_image:checked`)?.value ?? 'off';

            if (customPromptText === '' || customPromptText === null) {
                alert(wp.i18n.__('Please enter a prompt.', 'elyssa-ai'));
                hideLoadingIndicator();
                return;
            }

            const data = {
                'action': 'elyssa_ai_request',
                'text': customPromptText,
                'tone_of_voice': create_tone.value,
                'length': create_length.value,
                'keywords': create_keywords.value,
                'image': image,
                'image_prompt': result_image_prompt.value,
                'nonce': elyssaAiVars.nonce
            };

            fetch(elyssaAiVars.ajax_url, {
                method: 'POST',
                credentials: 'same-origin',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams(data)
            })
                .then(response => response.json())
                .then(data => {
                    hideLoadingIndicator();
                    console.log(data.data);
                    const { title, content, keywords, image } = data.data;

                    const tempDiv = document.createElement('div');
                    tempDiv.innerHTML = content;

                    const h2Elements = tempDiv.getElementsByTagName('h2');
                    for (let h2 of h2Elements) {
                        h2.classList.add('font-bold', 'text-lg', 'mt-2');
                    }

                    const h3Elements = tempDiv.getElementsByTagName('h3');
                    for (let h3 of h3Elements) {
                        h3.classList.add('font-bold', 'text-md', 'mt-2');
                    }

                    const pElements = tempDiv.getElementsByTagName('p');
                    for (let p of pElements) {
                        p.classList.add('leading-relaxed', 'mt-2');
                    }

                    content_wrapper.style.display = 'block';

                    content_message.innerHTML = '';
                    content_message.innerHTML = tempDiv.innerHTML;

                    content_title.innerHTML = '';
                    content_title.innerHTML = title;

                    if (result_title && result_title.parentNode) {
                        result_title.parentNode.removeChild(result_title);
                    }

                    content_message.dataset.content = content;
                    content_message.dataset.title = title;
                    content_message.dataset.keywords = keywords;

                    if (image) {
                        result_image.innerHTML = '<img src="' + image + '" id="elyssa_ai_content_image" alt="' + wp.i18n.__('elyssa ai image', 'elyssa-ai') + '" />';
                        result_image.style.display = 'block';
                    } else {
                        result_image.style.display = 'none';
                    }

                    if (create_type.value === 'pages') {
                        create_page.style.display = 'block';
                    } else if (create_type.value === 'posts') {
                        create_post.style.display = 'block';
                    }

                    if (keywords && keywords.length > 0) {
                        const keywordsElement = document.createElement('p');
                        keywordsElement.classList.add('mt-4', 'text-sm', 'text-gray-600');
                        content_keywords.innerHTML = keywords.join(', ');
                    }
                })
                .catch((error) => {
                    hideLoadingIndicator();
                    console.error('Error:', error);
                });
        });
    }

    var checkbox = document.getElementById('elyssa_ai_add_image');
    var input = document.getElementById('elyssa_ai_image_prompt');

    input.disabled = !checkbox.checked;

    checkbox.addEventListener('change', function() {
        input.disabled = !this.checked;
    });
});

document.getElementById('elyssa_ai_save_page').addEventListener('click', function () {
    const content = document.getElementById('elyssa_ai_content');
    const content_keywords = document.getElementById('elyssa_ai_keywords');
    const image = document.querySelector(`#elyssa_ai_add_image:checked`)?.value ?? 'off';
    const image_url = document.getElementById('elyssa_ai_content_image')?.src ?? '';

    var data = {
        'action': 'elyssa_ai_create_page',
        'title': content.dataset.title,
        'content': content.dataset.content,
        'tags': content_keywords.textContent,
        'image' : image ? image_url : 'off',
        'elyssa_ai_create_page_nonce': document.getElementById('elyssa_ai_create_page_nonce').value
    };
    console.log('Keywords being sent:', content_keywords.textContent);

    fetch(ajaxurl, {
        method: 'POST',
        credentials: 'same-origin',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: new URLSearchParams(data)
    })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                message = confirm(wp.i18n.__('Post created - redirect to it?', 'elyssa-ai'));
                if (message) {
                    window.location.href = '/wp-admin/post.php?post=' + data.data.post_id + '&action=edit';
                }
            } else {
                alert(wp.i18n.__('Error while creating the post', 'elyssa-ai'));
            }
        });
});

document.getElementById('elyssa_ai_save_post').addEventListener('click', function () {
    const content = document.getElementById('elyssa_ai_content');
    const content_keywords = document.getElementById('elyssa_ai_keywords');
    const image = document.querySelector(`#elyssa_ai_add_image:checked`)?.value ?? 'off';
    const image_url = document.getElementById('elyssa_ai_content_image')?.src ?? '';

    var data = {
        'action': 'elyssa_ai_create_post',
        'title': content.dataset.title,
        'content': content.dataset.content,
        'tags': content_keywords.textContent,
        'image' : image ? image_url : 'off',
        'elyssa_ai_create_post_nonce': document.getElementById('elyssa_ai_create_post_nonce').value
    };
    console.log('Keywords being sent:', content_keywords.textContent);

    fetch(ajaxurl, {
        method: 'POST',
        credentials: 'same-origin',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: new URLSearchParams(data)
    })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                message = confirm(wp.i18n.__('Post created - redirect to it?', 'elyssa-ai'));
                if (message) {
                    window.location.href = '/wp-admin/post.php?post=' + data.data.post_id + '&action=edit';
                }
            } else {
                alert(wp.i18n.__('Error while creating the post', 'elyssa-ai'));
            }
        });
});