<?php
if (!defined('ABSPATH')) {
    exit;
}
function elyssa_ai_register_services() {
    $service_dir = ELYSSA_AI_ROOT_PATH . 'includes/services/';
    $service_files = glob($service_dir . 'class-*-service.php');

    elyssa_ai_log('Elyssa AI: Found service files: ' . print_r($service_files, true));

    foreach ($service_files as $file) {
        $class_name = str_replace(['class-', '-service.php'], ['', '_Service'], basename($file));
        if ($class_name === 'ElyssaAI_Service') continue;

        require_once $file;

        if (class_exists($class_name) && is_subclass_of($class_name, 'ElyssaAI_Service')) {
            $service_info = $class_name::get_service_info();
            if (isset($service_info['types'])) {
                foreach ($service_info['types'] as $type) {
                    if ($type === 'text') {
                        ElyssaAI_ServiceFactory::register_text_service($service_info['id'], $class_name);
                    } elseif ($type === 'image') {
                        ElyssaAI_ServiceFactory::register_image_service($service_info['id'], $class_name);
                    }
                }
            }
        } else {
            elyssa_ai_log('Elyssa AI: Failed to register service: ' . $class_name);
        }
    }
}

// Call the function to register services
add_action('plugins_loaded', 'elyssa_ai_register_services');
