(function() {
    'use strict';

    function renderTextPreview(parsedData) {
        var resultContainer = document.getElementById('elyssa-ai-preview-result');
        var previewContent = document.getElementById('elyssa-ai-preview-content');

        if (parsedData && parsedData.title && parsedData.content) {
            var previewHtml = '<h3>' + parsedData.title + '</h3>' +
                parsedData.content;

            if (parsedData.keywords && parsedData.keywords.length > 0) {
                previewHtml += '<p><strong>Keywords:</strong> ' + parsedData.keywords.join(', ') + '</p>';
            }

            previewContent.innerHTML = previewHtml;
            resultContainer.style.display = 'block';
        } else {
            previewContent.innerHTML = '<p class="error">Invalid preview data</p>';
            resultContainer.style.display = 'none';
        }
    }

    function renderImagePreview(imageData) {
        var resultContainer = document.getElementById('elyssa-ai-preview-result');
        var previewContent = document.getElementById('elyssa-ai-preview-content');

        if (imageData && imageData.url) {
            var previewHtml = '<img src="' + imageData.url + '" alt="AI Generated Image" style="max-width:100%;">';
            previewHtml += '<p>Image ID: ' + imageData.id + '</p>';
            previewContent.innerHTML = previewHtml;
            resultContainer.style.display = 'block';
        } else {
            previewContent.innerHTML = '<p class="error">Invalid image data</p>';
            resultContainer.style.display = 'none';
        }
    }

    document.addEventListener('DOMContentLoaded', function() {
        var button = document.getElementById('elyssa-ai-generate-preview');
        var resultContainer = document.getElementById('elyssa-ai-preview-result');
        var previewContent = document.getElementById('elyssa-ai-preview-content');

        // Parse and render cached preview if it exists
        if (typeof elyssaAiPreview.cachedPreview !== 'undefined' && elyssaAiPreview.cachedPreview) {
            if (elyssaAiPreview.promptType === 'text') {
                renderTextPreview(elyssaAiPreview.cachedPreview);
            } else if (elyssaAiPreview.promptType === 'image') {
                renderImagePreview(elyssaAiPreview.cachedPreview);
            }
        }

        button.addEventListener('click', function(e) {
            e.preventDefault();

            var userPrompt = document.getElementById('elyssa_ai_user_prompt').value;
            var promptType = document.getElementById('elyssa_ai_prompt_type').value;
            var postId = document.getElementById('post_ID').value;

            button.disabled = true;
            button.textContent = elyssaAiPreview.generating;
            resultContainer.style.display = 'none';
            previewContent.innerHTML = '';

            var formData = new FormData();
            formData.append('action', 'elyssa_ai_preview_prompt');
            formData.append('nonce', elyssaAiPreview.nonce);
            formData.append('post_id', postId);
            formData.append('user_prompt', userPrompt);
            formData.append('prompt_type', promptType);

            fetch(elyssaAiPreview.ajax_url, {
                method: 'POST',
                credentials: 'same-origin',
                body: formData
            })
                .then(response => response.json())
                .then(data => {
                    console.log('AJAX response received:', data);
                    if (data.success) {
                        if (promptType === 'text') {
                            renderTextPreview(data.data);
                        } else if (promptType === 'image') {
                            renderImagePreview(data.data);
                        }
                    } else {
                        previewContent.innerHTML = '<p class="error">' + (data.data.message || elyssaAiPreview.error_occurred) + '</p>';
                        resultContainer.style.display = 'block';
                    }
                })
                .catch(error => {
                    console.error('AJAX error:', error);
                    previewContent.innerHTML = '<p class="error">' + elyssaAiPreview.error_occurred + '</p>';
                    resultContainer.style.display = 'block';
                })
                .finally(() => {
                    button.disabled = false;
                    button.textContent = elyssaAiPreview.generate_preview;
                });
        });
    });
})();