jQuery(document).ready(function ($) {
    document.getElementById('elyssa-ai-dashboard-prompt-select').addEventListener('change', function () {
        const promptId = this.value;
        if (promptId) {
            const data = new URLSearchParams({
                'action': 'elyssa_ai_dashboard_get_prompt_content',
                'prompt_id': promptId,
                'nonce': elyssaAiDashboard.prompt_nonce
            });

            fetch(elyssaAiDashboard.ajax_url, {
                method: 'POST',
                credentials: 'same-origin',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: data
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        document.getElementById('elyssa-ai-dashboard-prompt').value = data.data.user_prompt;
                    } else {
                        throw new Error(data.data.message || 'Unknown error occurred');
                    }
                })
                .catch((error) => {
                    console.error('Error:', error);
                    alert('Error: ' + error.message);
                });
        }
    });


    document.getElementById('elyssa-ai-dashboard-generate').addEventListener('click', function () {
        const prompt = document.getElementById('elyssa-ai-dashboard-prompt').value;
        if (!prompt) {
            alert('Please enter a prompt.');
            return;
        }

        document.getElementById('elyssa-ai-dashboard-loading').style.display = 'block';

        const data = new URLSearchParams({
            'action': 'elyssa_ai_dashboard_generate',
            'prompt': prompt,
            'nonce': elyssaAiDashboard.nonce
        });

        fetch(elyssaAiDashboard.ajax_url, {
            method: 'POST',
            credentials: 'same-origin',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: data
        })
            .then(response => response.json())
            .then(data => {
                document.getElementById('elyssa-ai-dashboard-loading').style.display = 'none';
                if (data.success) {
                    showGeneratedContentPopup(data.data.content);
                } else {
                    throw new Error(data.data.message || 'Unknown error occurred');
                }
            })
            .catch((error) => {
                document.getElementById('elyssa-ai-dashboard-loading').style.display = 'none';
                console.error('Error:', error);
                alert('An error occurred while generating content: ' + error.message);
            });
    });

    function showGeneratedContentPopup(data) {
        var overlay = $('<div id="elyssa-ai-overlay" style="position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.7); z-index: 9998;"></div>');
        var popup = $('<div id="elyssa-ai-generated-content-popup" style="position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 20px; border: 1px solid #ccc; max-width: 80%; max-height: 80%; overflow: auto; z-index: 9999;"></div>');
        var closeButton = $('<button style="position: absolute; top: 10px; right: 10px;">X</button>').on('click', function () {
            overlay.remove();
            popup.remove();
        });

        var titleDiv = $('<h1>' + data.title + '</h1>');
        var contentDiv = $('<div>' + data.content + '</div>');
        var createPageButton = $('<button class="button button-primary" style="margin-right: 10px;">Create Page</button>').on('click', function () {
            createContent('page', data.title, data.content);
        });
        var createPostButton = $('<button class="button button-primary">Create Post</button>').on('click', function () {
            createContent('post', data.title, data.content, data.keywords);
        });

        popup.append(
            closeButton,
            titleDiv,
            contentDiv,
            '<div style="margin-top: 20px;"></div>',
            '<hr />',
            '<div style="margin-top: 10px;"></div>',
            createPageButton,
            createPostButton
        );

        $('body').append(overlay, popup);
    }

    function createContent(type, title, content, keywords = null) {
        const data = new URLSearchParams({
            'action': 'elyssa_ai_create_content',
            'type': type,
            'title': title,
            'content': content,
            'keywords': keywords,
            'nonce': elyssaAiDashboard.nonce
        });

        fetch(elyssaAiDashboard.ajax_url, {
            method: 'POST',
            credentials: 'same-origin',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: data
        })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    const message = type.charAt(0).toUpperCase() + type.slice(1) + ' with title "' + title + '" created successfully.';
                    const editUrl = data.data.edit_url;

                    if (confirm(message + '\n\nDo you want to edit the ' + type + ' now?')) {
                        window.location.href = editUrl;
                    } else {
                        document.getElementById('elyssa-ai-generated-content-popup').remove();
                        document.getElementById('elyssa-ai-overlay').remove();
                    }
                } else {
                    throw new Error(data.data.message || 'Unknown error occurred');
                }
            })
            .catch((error) => {
                console.error('Error:', error);
                alert('An error occurred while creating the ' + type + ': ' + error.message);
            });
    }
});