# elyssa AI WordPress Plugin

## Description

elyssa AI is a powerful WordPress plugin that integrates artificial intelligence capabilities into your WordPress site. It leverages various AI services to generate content, images, and provide intelligent features for content creation and management.

## Features

- **Content Generation**: Create articles, blog posts, and pages using AI.
- **Image Generation**: Generate images based on text prompts.
- **Comment Analysis**: AI-powered rating and analysis of comments.
- **Bulk Generation**: Create multiple pieces of content at once.
- **AI Chat**: Interact with AI directly from the WordPress admin bar.
- **Multilingual Support**: Translate content into different languages.
- **Keyword Generation**: Generate relevant keywords for your content.
- **Customizable AI Services**: Choose from multiple AI providers for text and image generation.
- **Editor Integration**: Seamless integration with both Classic and Gutenberg editors.
- **Dashboard Widget**: Quick access to AI features from the WordPress dashboard.
- **Prompt Library**: Save and reuse custom prompts for efficient content creation.
- **API Key Encryption**: Enhanced security with encrypted storage of API keys.

## Installation

1. Download the `elyssa-ai.zip` file.
2. Log in to your WordPress admin panel.
3. Go to Plugins > Add New > Upload Plugin.
4. Choose the `elyssa-ai.zip` file and click "Install Now".
5. After installation, click "Activate Plugin".
6. Go to the elyssa AI settings page and configure your AI service preferences and API keys.

## Configuration

1. Navigate to the elyssa AI settings page in your WordPress admin panel.
2. Select your preferred AI services for text and image generation.
3. Enter the API keys for the selected services (keys are stored securely using encryption).
4. Adjust other settings such as maximum token length, timeout, and logging options.
5. Enable or disable features like comment rating as needed.

## Usage

### Content Generation

1. Go to the "Generate Articles" page under the elyssa AI menu.
2. Select the content type, tone of voice, and length.
3. Enter a prompt or select a pre-defined prompt from the prompt library.
4. Optionally, enable image generation and provide an image prompt.
5. Click "Generate" to create your content.

### Bulk Generation

1. Go to the "Bulk Generation" page under the elyssa AI menu.
2. Enter keywords and select the number of articles to generate.
3. Choose from the generated titles and create content for selected titles.

### Editor Integration

- In the Classic Editor: Use the elyssa AI metabox in the sidebar to access AI features.
- In Gutenberg: Use the elyssa AI sidebar to access AI features.

### Comment Analysis

1. Enable comment rating in the elyssa AI settings.
2. Go to the Comments page in your WordPress admin.
3. Use the "elyssa Rate It" button to analyze comments with AI.

### AI Chat

1. Click on the "elyssa AI Chat" option in the admin bar to open the chat interface.
2. Type your message and interact with the AI directly.

### Prompt Library

1. Go to the Prompt Database in the elyssa AI menu.
2. Create, edit, and manage your custom prompts for both text and image generation.

## Supported AI Services

Please refer to the privacy.txt for privacy information a service.

### Text Generation
- OpenAI (GPT-4, GPT-4 Turbo, etc.)
- Anthropic (Claude 3 Opus, Claude 3 Sonnet, etc.)
- DeepSeek (Deepseek Chat, Deepseek Coder)
- Google (Gemini 1.0 Pro, Gemini 1.5 Pro, etc.)
- Groq (Mixtral 8x7B, LLaMA models, etc.)
- Mistral (Mistral Large, Mistral Medium, etc.)

### Image Generation
- OpenAI (DALL-E 2, DALL-E 3)
- Stability AI (Stable Diffusion XL, etc.)
- Flux AI (Flux Pro 1.1 Ultra, Flux Pro 1.1, Flux Pro, Flux Dev)
- Leonardo AI (Phoenix)

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher

## Multilanguage Support
- English
- German
- French
- Spanish
- Italian
- Dutch
- Portuguese
- Polish
- Swedish
- Turkish
- Chinese (simplified)
- Japanese

## Frequently Asked Questions

**Q: How do I get API keys for the AI services?**
A: Visit the respective AI service provider's website to sign up and obtain API keys. Follow their documentation for details on how to acquire and manage your API keys.

**Q: Can I use multiple AI services simultaneously?**
A: Yes, you can configure different services for text and image generation.

**Q: Is the generated content unique?**
A: While the AI generates content based on your prompts, it's always recommended to review and potentially edit the output to ensure it meets your specific needs and standards.

**Q: How does the AI chat feature work?**
A: The AI chat feature allows you to interact directly with the AI from the WordPress admin bar. It uses the configured text generation service to provide responses to your queries.

**Q: Can I save my chat history?**
A: Yes, the AI chat feature allows you to save, load, and delete your chat history.

## Changelog

### 2.4
- Added: Manual update check feature in settings page
- Added: Improved update system reliability with automatic detection
- Added: Debug tools for WordPress update system (when logging enabled)
- Improved: Secured storage of API credentials with AES-256 encryption
- Added: Automatic encryption of existing API keys during update
- Updated: Settings interface with more update information
- Updated: Compatibility with WordPress 6.8
- Fixed: Various security improvements and code optimizations
- Fixed: Update detection issues

### 2.3
- Fixed: Issue with image generation error messages
- Updated: Improved compatibility with various API endpoints
- Added: Better error handling for API request failures
- Improved: UI responsiveness in admin interface

### 2.2
- Updated: registration process 
- Updated: documentation url to point to the new elyssa AI documentation site
- Improved: error handling for API requests
- Improved: performance of the bulk generation feature
- Added: support for manual entering model names in the settings - no longer limited to the dropdown
- Fixed: issue with the "elyssa Rate It" button not appearing in comments
- Fixed: - removed model definition in services

### 2.1
- Added: Automatic update system with server connection to wpupdate.codefabrica.net
- Added: Option to enable/disable automatic updates
- Added: Update notification and information display
- Added: Improved logging for update processes
- Fixed: Various minor bugs and improvements


### 2.0
- Added support for multiple new AI services including Anthropic, DeepSeek, Google, Groq, and Mistral
- Implemented a prompt library for saving and reusing custom prompts
- Enhanced bulk generation feature with title suggestions and manual additions
- Improved AI Chat feature with persistent chat history
- Added support for generating images with Leonardo AI
- Enhanced comment analysis capabilities with color-coded ratings
- Improved integration with both Classic and Gutenberg editors

### 1.0
- Initial release

## Support

For ideas or bugs, please email support@codefabrica.net. We provide limited support for free products.

## License

GPL v2

## Credits

elyssa AI is developed and maintained by [codefabrica.net](https://codefabrica.net).