// Elyssa AI Settings Page JavaScript
jQuery(document).ready(function($) {
    
    // Manueller Update-Check
    $('#elyssa-ai-check-update').on('click', function() {
        const $button = $(this);
        const $status = $('#elyssa-ai-update-status');
        
        // Button deaktivieren während des Checks
        $button.prop('disabled', true);
        $status.html(elyssaSettings.checking_text);
        
        // AJAX-Request zum Prüfen auf Updates
        $.ajax({
            url: elyssaSettings.ajaxurl,
            type: 'POST',
            data: {
                action: 'elyssa_ai_check_update',
                nonce: elyssaSettings.nonce
            },
            success: function(response) {
                if (response.success) {
                    if (response.data.update_available) {
                        // Update verfügbar
                        $status.html(
                            elyssaSettings.update_available_text + ' ' + response.data.version + ' ' +
                            '<a href="' + window.location.href + '">' + 
                            __('Refresh page to update', 'elyssa-ai') + '</a>'
                        );
                    } else {
                        // Kein Update verfügbar
                        $status.text(elyssaSettings.up_to_date_text);
                    }
                } else {
                    // Fehler bei der Anfrage
                    $status.text(elyssaSettings.error_text + ' ' + response.data.message);
                }
            },
            error: function(xhr, status, error) {
                // AJAX-Fehler
                $status.text(elyssaSettings.error_text + ' ' + error);
            },
            complete: function() {
                // Button wieder aktivieren
                $button.prop('disabled', false);
            }
        });
    });
    
    // Reset Transients Button
    $('#elyssa-ai-reset-transients').on('click', function() {
        const $button = $(this);
        
        // Button deaktivieren während des Prozesses
        $button.prop('disabled', true);
        
        // AJAX-Request zum Zurücksetzen der Transients
        $.ajax({
            url: elyssaSettings.ajaxurl,
            type: 'POST',
            data: {
                action: 'elyssa_ai_reset_transients',
                nonce: elyssaSettings.nonce
            },
            success: function(response) {
                if (response.success) {
                    alert('Transients have been reset successfully!');
                } else {
                    alert('Error: ' + response.data.message);
                }
            },
            error: function(xhr, status, error) {
                alert('AJAX Error: ' + error);
            },
            complete: function() {
                // Button wieder aktivieren
                $button.prop('disabled', false);
            }
        });
    });
    
    // Debug-Test für die Updateserver-Verbindung
    $('#elyssa-ai-test-connection').on('click', function() {
        const $button = $(this);
        const $debugInfo = $('#elyssa-ai-debug-info');
        
        // Button deaktivieren während des Tests
        $button.prop('disabled', true);
        $debugInfo.html('Testing connection...');
        
        // AJAX-Request zum Testen der Verbindung
        $.ajax({
            url: elyssaSettings.ajaxurl,
            type: 'POST',
            data: {
                action: 'elyssa_ai_test_update_connection',
                nonce: elyssaSettings.nonce
            },
            success: function(response) {
                if (response.success) {
                    // Erfolgreicher Test
                    let displayData = response.data;
                    // Pretty-print für JSON
                    let jsonStr = JSON.stringify(displayData, null, 2);
                    $debugInfo.html('<span style="color: green;">✓ Connection successful!</span><br><pre style="background:#f8f8f8; padding:10px; overflow:auto; max-height:300px; font-size:12px;">' + jsonStr + '</pre>');
                    
                    // WordPress-Transients prüfen
                    checkTransients();
                } else {
                    // Fehler bei der Anfrage
                    $debugInfo.html('<span style="color: red;">✗ Connection failed!</span><br>' + response.data.message + '<br><pre style="background:#f8f8f8; padding:10px; overflow:auto; max-height:300px; font-size:12px;">' + JSON.stringify(response.data, null, 2) + '</pre>');
                }
            },
            error: function(xhr, status, error) {
                // AJAX-Fehler
                $debugInfo.html('<span style="color: red;">✗ AJAX Error!</span><br>' + error);
            },
            complete: function() {
                // Button wieder aktivieren
                $button.prop('disabled', false);
            }
        });
    });
    
    // Prüfe WordPress Transients für Updates
    function checkTransients() {
        $.ajax({
            url: elyssaSettings.ajaxurl,
            type: 'POST',
            data: {
                action: 'elyssa_ai_check_transients',
                nonce: elyssaSettings.nonce
            },
            success: function(response) {
                if (response.success) {
                    $('#elyssa-ai-transient-info').html('<pre style="background:#f0f0f0; padding:10px; overflow:auto; max-height:200px; font-size:12px;">' + JSON.stringify(response.data, null, 2) + '</pre>');
                }
            }
        });
    }
    
    // Text-Übersetzungshilfen-Funktion
    function __(text, domain) {
        return text;
    }
});

