<?php
if (!defined('ABSPATH')) {
    exit;
}
abstract class ElyssaAIBaseService
{
    protected $text_service = null;
    protected $image_service = null;

    protected function init_text_service()
    {
        if ($this->text_service === null) {
            $service_name = get_option('elyssa_ai_text_service', '');
            if (!empty($service_name)) {
                try {
                    $this->text_service = ElyssaAI_ServiceFactory::get_text_service($service_name);
                } catch (Exception $e) {
                    $this->text_service = false;
                    return new WP_Error('ai_service_error', __('Error initializing Text AI service:', 'elyssa-ai') . ' ' . $e->getMessage());
                }
            } else {
                $this->text_service = false;
                return new WP_Error('ai_service_error', __('No Text AI service selected in settings.', 'elyssa-ai'));
            }
        }
        return true;
    }

    protected function init_image_service()
    {
        if ($this->image_service === null) {
            $service_name = get_option('elyssa_ai_image_service', '');
            if (!empty($service_name)) {
                try {
                    $this->image_service = ElyssaAI_ServiceFactory::get_image_service($service_name);
                } catch (Exception $e) {
                    $this->image_service = false;
                    return new WP_Error('ai_service_error', __('Error initializing Image AI service:', 'elyssa-ai') . ' ' . $e->getMessage());
                }
            } else {
                $this->image_service = false;
                return new WP_Error('ai_service_error', __('No Image AI service selected in settings.', 'elyssa-ai'));
            }
        }
        return true;
    }

    public function get_prompt_content_ajax_handler() {
        check_ajax_referer('elyssa_ai_prompt_nonce', 'nonce');

        if (!current_user_can('upload_files')) {
            wp_send_json_error(array('message' => __('Insufficient permissions', 'elyssa-ai')));
            return;
        }

        $prompt_id = isset($_POST['prompt_id']) ? intval($_POST['prompt_id']) : 0;

        if (!$prompt_id) {
            wp_send_json_error(array('message' => __('Invalid prompt ID', 'elyssa-ai')));
            return;
        }

        $user_prompt = get_post_meta($prompt_id, '_user_prompt', true);

        if ($user_prompt) {
            wp_send_json_success(array('user_prompt' => $user_prompt));
        } else {
            wp_send_json_error(array('message' => __('Prompt not found', 'elyssa-ai')));
        }
    }

}