<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Logs message to file in the uploads directory
 *
 * @param mixed $log Content to log
 * @return void
 */
function elyssa_ai_log($log) {
    // Überprüfe, ob das Logging aktiviert ist
    if (get_option('elyssa_ai_logging_enabled')) {
        $timestamp = gmdate('Ymd');
        $log = print_r($log, true);
        
        // Verwende den Upload-Ordner statt ABSPATH
        $upload_dir = wp_upload_dir();
        $log_dir = $upload_dir['basedir'] . '/elyssa-ai-logs';
        
        // Stelle sicher, dass der Log-Ordner existiert
        if (!file_exists($log_dir)) {
            wp_mkdir_p($log_dir);
            
            // Erstelle eine .htaccess-Datei, um direkten Zugriff zu verhindern
            file_put_contents($log_dir . '/.htaccess', 'Deny from all');
            
            // Erstelle eine index.php, um die Auflistung des Verzeichnisses zu verhindern
            file_put_contents($log_dir . '/index.php', '<?php // Silence is golden');
        }
        
        $log_file = $log_dir . "/elyssa-ai-{$timestamp}-log.txt";
        file_put_contents($log_file, "[" . gmdate('Y-m-d H:i:s') . "] " . $log . "\n", FILE_APPEND);
    }
}

/**
 * Log update server responses for debugging purposes
 *
 * @param mixed $response The response from the update server
 * @param string $context Context of the response (e.g., 'check_update', 'plugin_info')
 */
function elyssa_ai_log_update_response($response, $context = '') {
    if (get_option('elyssa_ai_logging_enabled', false)) {
        $log_message = "Update response ($context): ";
        
        if (is_wp_error($response)) {
            $log_message .= "Error: " . $response->get_error_message();
        } else {
            if (is_array($response) && isset($response['body'])) {
                $log_message .= $response['body'];
            } elseif (is_object($response) && method_exists($response, 'get_body')) {
                $log_message .= $response->get_body();
            } else {
                $log_message .= "Response format not recognized: " . print_r($response, true);
            }
        }
        
        elyssa_ai_log('Updater: ' . $log_message);
    }
}
