<?php
if (!defined('ABSPATH')) {
    exit;
}
class ServicePrompts
{
    public static function get_prompts($prompt = null)
    {
        return [
            'generate_text' => [
                'system' => 'You are a content writer who creates stunning seo texts perfect for google ranking.',
                'user' => "$prompt

Return format:

Please divide the answer into three parts: A very descriptive and catchy title, the main content with the text, divided into sections and subsections, and a list of keywords that describe the content of the text. Please separate the three parts with a blank line.

Here's what we expect as return format:

TITLE: [Title of the article]
CONTENT: [Main content of the article]
KEYWORDS: [Comma-separated list of keywords]

Please do only return Main content in the CONTENT field. Do not return the title in the article content, only as extra field in the response.
Do only return the HTML body, not the title or header! Do not return Markdown Format! Do not return surrounding ```html or ```json or any other tags!",
            ],
            'translate_text' => [
                'system' => 'You are a professional translator.',
                'user' => "Translate the following text to %s: 
                
%s
        
(Please leave the formatting as is! Do not change the formatting of the text!) 

Return format:
Please be sure to reply in the following format - three parts separated by a blank line:

TITLE: [Title of the article]
CONTENT: [Main content of the article]
KEYWORDS: [Comma-separated list of keywords]

Please do only return Main content in the CONTENT field. Do not return the title in the article content, only as extra field in the response.
Do only return the HTML body, not the title or header! Do not return Markdown Format! Do not return surrounding ```html or ```json or any other tags!",
            ],
            'create_text' => [
                'system' => 'You are an expert content creator specializing in SEO-optimized articles.',
                'user' => "Write a well-structured article on the topic '$prompt' that is both optimized for search engines and appealing to human readers. Keep the following points in mind:

Please structure the article as follows:

A compelling introduction that introduces the main topic and grabs the reader's interest.
3-5 main sections that cover different aspects of the topic. Each section should
A clear heading (H2)
Include the main keyword and at least one secondary keyword, of course
Be informative and valuable to the reader
Be between 150-300 words long
Use subheadings (H3) for subsections where appropriate
A short conclusion that summarizes the main points and includes a call to action

Return format:

Please divide the answer into three parts: A very descriptive and catchy title, the main content with the text, divided into sections and subsections, and a list of keywords that describe the content of the text. Please separate the three parts with a blank line.

Here's what we expect as return format:

TITLE: [Title of the article]
CONTENT: [Main content of the article]
KEYWORDS: [Comma-separated list of keywords]

Please do only return Main content in the CONTENT field. Do not return the title in the article content, only as extra field in the response.
Do only return the HTML body, not the title or header! Do not return Markdown Format! Do not return surrounding ```html or ```json or any other tags!",
            ],
            'rewrite_text' => [
                'system' => 'You are an expert content editor and rewriter.',
                'user' => "Rewrite the following content, maintaining its meaning but improving its style and clarity: 
                
(Please try to keep the formatting as good as possible. If not possible, please format the text with headings, subheadings, etc.).
                
$prompt

Return format:
Please be sure to reply in the following format:
TITLE: [Title of the article]
CONTENT: [Main content of the article]
KEYWORDS: [Comma-separated list of keywords]

Please do only return Main content in the CONTENT field. Do not return the title in the article content, only as extra field in the response.
Do only return the HTML body, not the title or header! Do not return Markdown Format! Do not return surrounding ```html or ```json or any other tags!",
            ],
            'write_content' => [
                'system' => 'You are a versatile content writer capable of adapting to various tones and styles.',
                'user' => "Write a well-structured article on the topic '%s' that is both optimized for search engines and appealing to human readers. Keep the following points in mind:

Subsidiary keywords: %s.
Approximate text length: %s.
Tone of voice: %s.

Please structure the article as follows:

A compelling introduction that introduces the main topic and grabs the reader's interest.
3-5 main sections that cover different aspects of the topic. Each section should
A clear heading (H2)
Include the main keyword and at least one secondary keyword, of course
Be informative and valuable to the reader
Use subheadings (H3) for subsections where appropriate
A short conclusion that summarizes the main points and includes a call to action

Return format:

Please divide the answer into three parts: A very descriptive and catchy title, the main content with the text, divided into sections and subsections, and a list of keywords that describe the content of the text. Please separate the three parts with a blank line.

Here's what we expect as return format:

TITLE: [Title of the article]
CONTENT: [Main content of the article]
KEYWORDS: [Comma-separated list of keywords]

Please do only return Main content in the CONTENT field. Do not return the title in the article content, only as extra field in the response.
Do only return the HTML body, not the title or header! Do not return Markdown Format! Do not return surrounding ```html or ```json or any other tags!",
            ],
            'generate_keywords' => [
                'system' => 'You are an SEO expert specializing in keyword research.',
                'user' => "Generate a comma-separated list of 5-10 relevant keywords for the following content. Focus on the main topics and themes. Here's the content:               
%s

Return format:
Please be sure to reply in the following format:

KEYWORDS: [Comma-separated list of keywords]

Do only return in plain text - no HTML, no Markdown!",


            ],
            'prompt_preview' => [
                'system' => '',
                'user' => "%s

Return format:

Please divide the answer into three parts: A very descriptive and catchy title, the main content with the text, divided into sections and subsections, and a list of keywords that describe the content of the text. Please separate the three parts with a blank line.

Here's what we expect as return format:

TITLE: [Title of the article]
CONTENT: [Main content of the article]
KEYWORDS: [Comma-separated list of keywords]

Please do only return Main content in the CONTENT field. Do not return the title in the article content, only as extra field in the response.
Do only return the HTML body, not the title or header! Do not return Markdown Format! Do not return surrounding ```html or ```json or any other tags!",
            ],
            'analyze_comment' => [
                'system' => 'You are a SPAM expert specialized in comment analysis.',
                'user' => "Analyze the following comment in the context of this blog post. 
Blog post title: '%s'
Blog post content (truncated): %s...
Comment to evaluate: %s

Please rate this comment based on the following criteria:
1. Relevance to the blog post
2. Constructiveness of the comment
3. Tone and appropriateness
4. Potential for fostering discussion

Categorize the comment as:
- 'green' (valuable and appropriate)
- 'yellow' (questionable or needs moderation)
- 'red' (spam, inappropriate, or should be removed)

Provide your rating in the following format:
Color: [chosen color]
Reason: [brief explanation in 1-2 sentences]",
            ],
            'generate_titles' => [
                'system' => 'You are a content writer who creates stunning seo titles perfect for google ranking.',
                'user' => "Generate %d unique and engaging article titles based on the following keywords: %s. 
    Return the titles as a numbered list, one title per line, in the following format:
    1. First headline
    2. Second headline
    3. Third headline
    ...",
            ],
            'generate_bulk_content' => [
                'system' => 'You are a content writer who creates stunning seo texts perfect for google ranking.',
                'user' => "Write an article about a topic with the title '%s'. Remain the title unchanged! The article should be optimized for a human reader and of course search engines.
The keyword/keywords '%s' should be part of the article and naturally integrated into the body text. The article should be a %s.
                
Please structure the article as follows:
A compelling introduction that introduces the main topic and grabs the reader's interest.
3-5 main sections that cover different aspects of the topic. Each section should
A clear heading (H2)
Be informative and valuable to the reader
Be between 150-300 words long
Use subheadings (H3) for subsections where appropriate
A short conclusion that summarizes the main points and includes a call to action                

Return format:

Please divide the answer into three parts: A very descriptive and catchy title, the main content with the text, divided into sections and subsections, and a list of keywords that describe the content of the text. Please separate the three parts with a blank line.

Here's what we expect as return format:

TITLE: [Title of the article]
CONTENT: [Main content of the article]
KEYWORDS: [Comma-separated list of keywords]

Please do only return Main content in the CONTENT field. Do not return the title in the article content, only as extra field in the response.
Do only return the HTML body, not the title or header! Do not return Markdown Format! Do not return surrounding ```html or ```json or any other tags!",
            ],
        ];
    }

    public static function get_prompt($type, $prompt = null)
    {
        $prompts = self::get_prompts($prompt);
        return $prompts[$type] ?? null;
    }

    public static function get_system($type, $prompt = null)
    {
        $prompt = self::get_prompt($type, $prompt);
        return $prompt['system'] ?? null;
    }

    public static function get_user($type, $prompt = null)
    {
        $prompt = self::get_prompt($type, $prompt);
        return $prompt['user'] ?? null;
    }
}