<?php
function elyssa_ai_registration_page()
{
    include ELYSSA_AI_ROOT_PATH . 'admin/html/header.php';

    add_filter('https_ssl_verify', '__return_false');

    // Check if form is submitted
    if (isset($_POST['elyssa_ai_register'])) {
        check_admin_referer('elyssa_ai_register_action', 'elyssa_ai_register_nonce');

        $email = sanitize_email(wp_unslash($_POST['email'] ?? ''));
        $key = sanitize_text_field(wp_unslash($_POST['key'] ?? ''));
        $domain = sanitize_text_field(wp_unslash($_POST['domain'] ?? ''));

        // Verify the purchase
        $response = wp_remote_post(
            add_query_arg(
                array(
                    'key' => $key,
                    'email' => $email,
                    'domain' => $domain,
                    'title' => 'elyssa-ai',
                    'version' => ELYSSA_AI_VERSION,
                    'stats' => array(
                        'wordpress_version' => get_bloginfo('version')
                    ),
                ),
                'https://api.codefabrica.test/plugin/register'
            ),
            array(
                'headers' => array(
                    'Accept' => 'application/json',
                ),
            )
        );

        if (is_wp_error($response)) {
            $message = $response->get_error_message();
            $success = false;
        } else {
            $body = wp_remote_retrieve_body($response);
            $data = json_decode($body, true);
            $success = wp_remote_retrieve_response_code($response) === 200;

            if (isset($data['message'])) {
                $message = $data['message'];
            } elseif (isset($data['error'])) {
                $message = $data['error'];
                $success = false;
            } else {
                $message = __('Unknown response from the server', 'elyssa-ai');
                $success = false;
            }

            if ($success) {
                update_option('elyssa_ai_registered', true);
            }
        }
    }

    $is_registered = get_option('elyssa_ai_registered', false);
    $current_domain = wp_parse_url(get_site_url(), PHP_URL_HOST);
    ?>
    <div class="wrap">
        <div class="flex gap-6">
            <section class="bg-white p-6 shadow-md rounded-lg">
                <h2 class="text-xl font-semibold mb-4"><?php esc_html_e('Elyssa AI Registration (optional)', 'elyssa-ai'); ?></h2>
                <?php if (isset($message)): ?>
                    <div class="notice notice-<?php echo $success ? 'success' : 'error'; ?> is-dismissible">
                        <p><?php echo esc_html($message); ?></p>
                    </div>
                <?php endif; ?>
                <p><?php echo esc_html('Please register your copy of the plug-in. Email is optional. If you enter your e-mail address, you allow us to use it for a newsletter. You\'ll receive an email to verify.', 'elyssa-ai') ?></p>
                    <form method="post" action="">
                        <?php wp_nonce_field('elyssa_ai_register_action', 'elyssa_ai_register_nonce'); ?>
                        <table class="form-table">
                            <?php if (!$is_registered): ?>
                            <tr>
                                <th scope="row"><label for="key"><?php esc_html_e('Registration Key', 'elyssa-ai'); ?></label>
                                </th>
                                <td><input type="text" id="key" name="key" class="regular-text"
                                        <?php if($is_registered) echo 'readonly disabled'; ?>
><p class="text-xs"><?php echo esc_html('Get your free registration key') ?> <a href="https://elyssaai.com/register" target="_blank" class="font-bold"><?php echo esc_html('here') ?></a>.</p></td>
                            </tr>
                            <tr>
                                <th scope="row"><label for="email"><?php esc_html_e('Email (optional)', 'elyssa-ai'); ?></label>
                                </th>
                                <td><input type="email" id="email" name="email" class="regular-text"
                                        <?php if($is_registered) echo 'readonly disabled'; ?>
                                    ></td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <th scope="row"><label for="domain"><?php esc_html_e('Domain', 'elyssa-ai'); ?></label></th>
                                <td><input type="text" id="domain" name="domain" class="regular-text"
                                        <?php if($is_registered) echo 'disabled'; ?>
                                           value="<?php echo esc_attr($current_domain); ?>" readonly></td>
                            </tr>
                        </table>
                        <p class="submit">
                            <input type="submit" name="elyssa_ai_register" class="elyssa-ai-button"
                                <?php if($is_registered) echo 'disabled'; ?>
                                   value="<?php esc_html_e('Register elyssa AI PlugIn', 'elyssa-ai'); ?>">
                        </p>
                    </form>
                <?php if ($is_registered): ?>
                    <p class="text-green-700 font-medium mt-10 border border-green-900 px-2 py-1 rounded text-center"><?php esc_html_e('Your plugin is registered. Thank you for your registration!', 'elyssa-ai'); ?></p>
                <?php endif; ?>
            </section>
            <?php if (!$is_registered): ?>
            <section class="bg-white p-6 shadow-md rounded-lg">
                <h2 class="text-xl font-semibold mb-4"><?php esc_html_e('Information we send', 'elyssa-ai'); ?></h2>
                <?php if (isset($message)): ?>
                    <div class="notice notice-<?php echo $success ? 'success' : 'error'; ?> is-dismissible">
                        <p><?php echo esc_html($message); ?></p>
                    </div>
                <?php endif; ?>
                <p><?php echo esc_html_e('We want you to know what information we send to our registration server to be fully transparent.', 'elyssa-ai') ?></p>
                <p class="mt-5"><strong><?php echo esc_html_e('Registration Server: ', 'elyssa-ai') ?></strong> https://api.codefabrica.net/plugin/register</p>
                <p class="mt-5"><?php echo esc_html_e('Data:', 'elyssa-ai') ?></p>
                <pre>
{
    "key": "Your provided Key",
    "email": "Your provided Email",
    "domain": "<?php echo esc_html($current_domain); ?>",
    "title": "elyssa-ai",
    "version": "<?php echo esc_html(ELYSSA_AI_VERSION); ?>",
    "wordpress_version": "<?php echo esc_html(get_bloginfo('version')); ?>"
}
                    </pre>
                <p><?php echo esc_html_e('That\'s it already! We do not collect any more data. The email is used for a newsletter, the rest of the data for statistical purposes, whether it makes sense to develop the plug-in further or not.', 'elyssa-ai') ?></p>
            </section>
            <?php endif; ?>
        </div>
    </div>
    <?php
    include ELYSSA_AI_ROOT_PATH . 'admin/html/footer.php';
}