document.addEventListener('DOMContentLoaded', function () {
    const modal = document.getElementById('elyssa-ai-media-modal');
    const openModalButtons = document.querySelectorAll('#elyssa-ai-media-open-modal');
    const span = document.getElementsByClassName('elyssa-ai-media-close')[0];
    const generateButton = document.getElementById('elyssa-ai-media-generate');
    const saveButton = document.getElementById('elyssa-ai-media-save');
    const promptTextarea = document.getElementById('elyssa-ai-media-prompt');
    const resultDiv = document.getElementById('elyssa-ai-media-result');
    const promptSelect = document.getElementById('elyssa-ai-media-prompt-select');

    if (promptSelect) {
        promptSelect.addEventListener('change', function () {
            if (this.value) {
                fetch(elyssaAiMediaVars.ajax_url, {
                    method: 'POST',
                    credentials: 'same-origin',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: new URLSearchParams({
                        'action': 'elyssa_ai_media_get_prompt_content',
                        'prompt_id': this.value,
                        'nonce': elyssaAiMediaVars.prompt_nonce
                    })
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            promptTextarea.value = data.data.user_prompt;
                        } else {
                            throw new Error(data.data?.message || wp.i18n.__('Unknown error occurred', 'elyssa-ai'));
                        }
                    })
                    .catch((error) => {
                        console.error('Error:', error);
                        alert(`${wp.i18n.__('Error:', 'elyssa-ai')} ${error.message}`);
                    });
            }
        });
    }

// Check user permissions
    if (!elyssaAiMediaVars.can_upload) {
        openModalButtons.forEach(button => button.style.display = 'none');
        return;
    }

    openModalButtons.forEach(button => {
        button.addEventListener('click', function (e) {
            e.preventDefault();
            modal.style.display = "block";
        });
    });

    span.onclick = function () {
        modal.style.display = "none";
    }

    window.onclick = function (event) {
        if (event.target == modal) {
            modal.style.display = "none";
        }
    }

    generateButton.addEventListener('click', function () {
        const prompt = promptTextarea.value;

        if (prompt !== '') {
            generateButton.disabled = true;
            generateButton.textContent = wp.i18n.__('Generating...', 'elyssa-ai');
            resultDiv.innerHTML = '<div class="elyssa-ai-media-spinner"></div>';

            const data = {
                'action': 'elyssa_ai_media_request',
                'prompt': prompt,
                'nonce': elyssaAiMediaVars.media_nonce
            };

            fetch(elyssaAiMediaVars.ajax_url, {
                method: 'POST',
                credentials: 'same-origin',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams(data)
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        resultDiv.innerHTML = `<img src="${data.data.image}" alt="${wp.i18n.__('Generated image', 'elyssa-ai')}" class="elyssa-ai-media-generated-image">`;
                        saveButton.style.display = 'block';
                    } else {
                        throw new Error(data.data.message || wp.i18n.__('Unknown error occurred', 'elyssa-ai'));
                    }
                })
                .catch((error) => {
                    console.error('Error:', error);
                    resultDiv.innerHTML = `<p class="elyssa-ai-media-error">${wp.i18n.__('Error:', 'elyssa-ai')} ${error.message}</p>`;
                })
                .finally(() => {
                    generateButton.disabled = false;
                    generateButton.textContent = wp.i18n.__('Generate Image', 'elyssa-ai');
                });
        } else {
            alert(wp.i18n.__('Please enter a prompt', 'elyssa-ai'));
        }
    });

    saveButton.addEventListener('click', function () {
        const imageElement = resultDiv.querySelector('img');
        if (!imageElement) {
            alert(wp.i18n.__('No image to save', 'elyssa-ai'));
            return;
        }

        saveButton.disabled = true;
        saveButton.textContent = wp.i18n.__('Saving...', 'elyssa-ai');

        const data = {
            'action': 'elyssa_ai_media_save_request',
            'image': imageElement.src,
            'prompt': promptTextarea.value,
            'nonce': elyssaAiMediaVars.media_nonce
        };

        fetch(elyssaAiMediaVars.ajax_url, {
            method: 'POST',
            credentials: 'same-origin',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: new URLSearchParams(data)
        })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    if (elyssaAiMediaVars.is_media_library) {
                        alert(data.data.message);
                        modal.style.display = "none";
                        // Refresh the media library
                        window.location.reload();
                    } else {
                        // Insert the image into the editor
                        const imageHtml = `
                        <figure class="wp-block-image size-full">
                            <img src="${data.data.url}" alt="${data.data.description}" width="${data.data.width}" height="${data.data.height}" />
                            <figcaption>${data.data.description}</figcaption>
                        </figure>
                    `;
                        if (typeof wp !== 'undefined' && wp.media && wp.media.editor) {
                            wp.media.editor.insert(imageHtml);
                        } else {
                            // Fallback for classic editor
                            window.send_to_editor(imageHtml);
                        }
                        modal.style.display = "none";
                    }
                } else {
                    throw new Error(data.data.message || wp.i18n.__('Unknown error occurred', 'elyssa-ai'));
                }
            })
            .catch((error) => {
                console.error('Error:', error);
                alert(`${wp.i18n.__('Error:', 'elyssa-ai')} ${error.message}`);
            })
            .finally(() => {
                saveButton.disabled = false;
                saveButton.textContent = elyssaAiMediaVars.is_media_library ? wp.i18n.__('Save to Media Library', 'elyssa-ai') : wp.i18n.__('Save to Media Library and Insert', 'elyssa-ai');
            });
    });
});